<?php
// Function to generate the signature hash
function generateSignature($params, $key) {
    ksort($params); // Sort parameters alphabetically
    $stringToSign = "";
    foreach ($params as $param_key => $param_value) {
        $stringToSign .= $param_key . "=" . $param_value . "&"; // Concatenate parameters
    }
    $stringToSign = rtrim($stringToSign, "&"); // Remove the last "&"
    $stringToSign .= "&key=" . $key; // Append the API key to the string
    return strtoupper(md5($stringToSign)); // Return MD5 hash in uppercase
}

include('c.php');
// Current Unix timestamp in seconds
$timestampSeconds = time(); // Example: 1721017685 (this is dynamically generated)
 
// Prepare the parameters for the API request
$params = [
    'app_id' => $app_id,
    'time' => $timestampSeconds, // Current timestamp in seconds
];

// Generate the signature
$params['sign'] = generateSignature($params, $key);

// API URL
$api_url = "https://www.lg-pay.com/api/deposit/balance";

// Initialize cURL for the API request
$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params)); // Convert the parameters to query string
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Get the response as a string
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/x-www-form-urlencoded'
]);

// Execute the request and capture the response
$response = curl_exec($ch);
curl_close($ch);

// Decode the JSON response
$responseData = json_decode($response, true);

// Check if the request was successful
if ($responseData['status'] == 1) {
    // The balance is returned in cents
 echo   $balance = $responseData['data']['balance'] / 100; // Convert balance to actual amount in currency
   // For INR, you can customize the currency symbol
} else {
    echo "Error: " . $responseData['msg'];
}
?>
