<?php
date_default_timezone_set('Asia/Kolkata');

function waitForSecond($interval)
{
	while (true) {
		$currentSecond = (int) date('s');
		$currentMinute = (int) date('i');
		// Calculate which second in the minute we should be at (0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57 for 3 min)
		// For 3 min intervals, periods start at :00, :03, :06, etc. of each minute
		$targetSecond = ($currentMinute % $interval) * 60;
		if ($currentSecond >= $targetSecond && $currentSecond < $targetSecond + 1) {
			break;
		}
		usleep(100000);
	}
}

// Wait for the next 3-minute interval (00, 03, 06, 09, 12, 15, 18, 21, 24, 27, 30, 33, 36, 39, 42, 45, 48, 51, 54, 57 seconds)
$currentSecond = (int) date('s');
$currentMinute = (int) date('i');
$targetSecond = ($currentMinute % 3) * 60;
if ($currentSecond != $targetSecond) {
	waitForSecond(3);
}

include("serive/samparka.php");

try {
	include("nayakaphalitansa_mulaka_unohs_drei.php");

	$prathama = date('Ymd') . "10002" . sprintf("%04d", 1);
	$sesa = $lastperiodid = date('Ymd') . "10002" . sprintf("%04d", 480);

	$ajitarika = date('Ymd');
	// Calculate sequence number (1-480 for 3-minute intervals in a day)
	$timeInSeconds = time() % 86400;
	$sequenceNumber = intval($timeInSeconds / 180) + 1; // 1-based (1 to 480) - 180 seconds = 3 minutes
	if ($sequenceNumber > 480) {
		$sequenceNumber = 1; // Reset to 1 if exceeds max
	}
	$uniqueSequence = str_pad($sequenceNumber, 4, '0', STR_PAD_LEFT);

	$bartamankalakrama = $ajitarika . "10002" . $uniqueSequence;

	$tarika = date('Y-m-d H:i:s');

	$dekhakalakrama = mysqli_query($conn, "select atadaaidi from `gelluonduhogu_drei` order by kramasankhye desc limit 1");
	$kaladhadi = mysqli_num_rows($dekhakalakrama);
	$kalakramadhadi = mysqli_fetch_array($dekhakalakrama);

	$lastPeriod = $kalakramadhadi ? $kalakramadhadi['atadaaidi'] : null;
	$lastDate = $lastPeriod ? substr($lastPeriod, 0, 8) : null;

	// Check if it's a new day
	if ($lastDate != $ajitarika) {
		// New day, truncate and insert first period
		$katiba = mysqli_query($conn, "TRUNCATE TABLE `gelluonduhogu_drei`");
		$tathya = mysqli_query($conn, "INSERT INTO `gelluonduhogu_drei` (`atadaaidi`,`dinankavannuracisi`) VALUES ('" . $bartamankalakrama . "','" . $tarika . "')");
	} else {
		// Same day, check if period already exists
		$checkPeriod = mysqli_query($conn, "SELECT atadaaidi FROM `gelluonduhogu_drei` WHERE atadaaidi = '" . $bartamankalakrama . "' LIMIT 1");
		$periodExists = mysqli_num_rows($checkPeriod);

		if ($periodExists == 0) {
			// Period doesn't exist, insert it
			$tathya = mysqli_query($conn, "INSERT INTO `gelluonduhogu_drei` (`atadaaidi`,`dinankavannuracisi`) VALUES ('" . $bartamankalakrama . "','" . $tarika . "')");
		} else {
			// Period exists, update timestamp
			$tathya = mysqli_query($conn, "UPDATE `gelluonduhogu_drei` SET `dinankavannuracisi` = '" . $tarika . "' WHERE `atadaaidi` = '" . $bartamankalakrama . "'");
		}
	}

	$safa_shonu = mysqli_query($conn, "UPDATE hastacalita_phalitansa_drei SET sthiti='0'");

} finally {
	if (isset($conn) && $conn instanceof mysqli) {
		mysqli_close($conn);
	}
	$conn = null;
}
?>