<?php
date_default_timezone_set('Asia/Kolkata');

function waitForSecond($desiredSecond)
{
	while (true) {
		$currentSecond = date('s');
		if ($currentSecond == $desiredSecond) {
			break;
		}
		usleep(100000);
	}
}

waitForSecond('00');

include("serive/samparka.php");

try {
	include("nayakaphalitansa_mulaka_unohs.php");

	$currentDate = date('Ymd');

	// Calculate sequence number (1-1440 for 1-minute intervals in a day)
	$timeInSeconds = time() % 86400;
	$sequenceNumber = intval($timeInSeconds / 60) + 1; // 1-based (1 to 1440)
	if ($sequenceNumber > 1440) {
		$sequenceNumber = 1; // Reset to 1 if exceeds max
	}
	$uniqueSequence = str_pad($sequenceNumber, 4, '0', STR_PAD_LEFT);

	$bartamankalakrama = $currentDate . "10001" . $uniqueSequence;
	$prathama = $currentDate . "10001" . "0001"; // First period of the day
	$sesa = $currentDate . "10001" . "1440"; // Last period of the day

	$tarika = date('Y-m-d H:i:s');

	$dekhakalakrama = mysqli_query($conn, "SELECT atadaaidi FROM `gelluonduhogu` ORDER BY kramasankhye DESC LIMIT 1");
	$kaladhadi = mysqli_num_rows($dekhakalakrama);
	$kalakramadhadi = mysqli_fetch_array($dekhakalakrama);

	if ($kaladhadi == 0 || $kalakramadhadi == null) {
		// No records, insert new period
		$tathya = mysqli_query($conn, "INSERT INTO `gelluonduhogu` (`atadaaidi`,`dinankavannuracisi`) VALUES ('" . $bartamankalakrama . "','" . $tarika . "')");
	} else {
		$lastPeriod = $kalakramadhadi['atadaaidi'];
		$lastDate = substr($lastPeriod, 0, 8);

		// Check if it's a new day
		if ($lastDate != $currentDate) {
			// New day, truncate and insert first period
			$katiba = mysqli_query($conn, "TRUNCATE TABLE `gelluonduhogu`");
			$tathya = mysqli_query($conn, "INSERT INTO `gelluonduhogu` (`atadaaidi`,`dinankavannuracisi`) VALUES ('" . $bartamankalakrama . "','" . $tarika . "')");
		} else {
			// Same day, check if period already exists
			$checkPeriod = mysqli_query($conn, "SELECT atadaaidi FROM `gelluonduhogu` WHERE atadaaidi = '" . $bartamankalakrama . "' LIMIT 1");
			$periodExists = mysqli_num_rows($checkPeriod);

			if ($periodExists == 0) {
				// Period doesn't exist, insert it
				$tathya = mysqli_query($conn, "INSERT INTO `gelluonduhogu` (`atadaaidi`,`dinankavannuracisi`) VALUES ('" . $bartamankalakrama . "','" . $tarika . "')");
			} else {
				// Period exists, update timestamp
				$tathya = mysqli_query($conn, "UPDATE `gelluonduhogu` SET `dinankavannuracisi` = '" . $tarika . "' WHERE `atadaaidi` = '" . $bartamankalakrama . "'");
			}
		}
	}

	$safa_shonu = mysqli_query($conn, "UPDATE hastacalita_phalitansa SET sthiti='0'");

} finally {
	if (isset($conn) && $conn instanceof mysqli) {
		mysqli_close($conn);
	}
	$conn = null;
}
?>