<?php
// Timezone
date_default_timezone_set('Asia/Dhaka');

// Database connect
include "../../conn.php";

// User ID receive
$userid = intval($_GET['userid'] ?? 0);

// Static Bank List
$banks = [
    [
        "bankID"   => 175,
        "bankLogo" => "https://i.postimg.cc/Kz4PmYS7/Bkash-logo.jpg",
        "bankName" => "BKASH",
        "reserved" => "4"
    ],
    [
        "bankID"   => 178,
        "bankLogo" => "https://i.postimg.cc/2yQVYp6b/1679248787Nagad-Logo.png",
        "bankName" => "NAGAD",
        "reserved" => "4"
    ],
    [
        "bankID"   => 176,
        "bankLogo" => "https://ossimg.dkwinpicture.com/dkwin",
        "bankName" => "ROCKET",
        "reserved" => "4"
    ],
    [
        "bankID"   => 177,
        "bankLogo" => "https://ossimg.dkwinpicture.com/dkwin",
        "bankName" => "UPAY",
        "reserved" => "4"
    ],
    [
        "bankID"   => 237,
        "bankLogo" => "https://ossimg.dkwinpicture.com/dkwin",
        "bankName" => "Surecash",
        "reserved" => "4"
    ],
];

// ===============================
// Load user bank accounts from DB
// ===============================

$userBanks = [];

$sql = "SELECT id, account, name, type 
        FROM bankcard 
        WHERE userid = '$userid'
        ORDER BY id DESC";

$q = $conn->query($sql);

if ($q && $q->num_rows > 0) {
    while ($row = $q->fetch_assoc()) {
        $userBanks[] = [
            "id"      => $row['id'],
            "account" => $row['account'],
            "name"    => $row['name'],
            "type"    => $row['type']
        ];
    }
}

// Final Response
$response = [
    "data" => [
        "banklist" => $banks,      // Static bank list
        "userbank" => $userBanks   // User-added bank accounts from bankcard table
    ],
    "code" => 0,
    "msg" => "Succeed",
    "msgCode" => 0,
    "serviceNowTime" => date('Y-m-d H:i:s')
];

header('Content-Type: application/json; charset=utf-8');
echo json_encode($response, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
