<?php
include('conn.php');
header('Content-Type: application/json; charset=utf-8');

// ---------- 0) Read body ----------
$raw = file_get_contents("php://input");

// Always log hit (so you can verify callback is reaching)
file_put_contents(__DIR__ . "/callback_hit.log", date('c') . " HIT\n", FILE_APPEND);

// If body empty (browser open / proxy ping), return OK to avoid blocking
if (!$raw || trim($raw) === '') {
    http_response_code(200);
    echo json_encode(["ok" => true, "msg" => "no payload"]);
    exit;
}

// Log raw payload (for debugging & future mapping)
file_put_contents(__DIR__ . "/callback_payload.log", date('c') . " " . $raw . "\n", FILE_APPEND);

// Decode JSON
$data = json_decode($raw, true);
if (!is_array($data)) {
    http_response_code(200);
    echo json_encode(["ok" => true, "msg" => "invalid json"]);
    exit;
}

// ---------- 1) Flexible field mapping ----------
$game_uid   = (string)($data['game_uid'] ?? $data['gameCode'] ?? $data['game'] ?? '');
$round_id   = (string)($data['game_round'] ?? $data['round_id'] ?? $data['roundId'] ?? $data['round'] ?? '');
$accountRaw = (string)($data['member_account'] ?? $data['username'] ?? $data['user'] ?? $data['account'] ?? $data['uid'] ?? '');

$bet_amount = (float)($data['bet_amount'] ?? $data['betAmount'] ?? $data['bet'] ?? 0);
$win_amount = (float)($data['win_amount'] ?? $data['winAmount'] ?? $data['win'] ?? 0);

$vendorCode = (string)($data['vendor_code'] ?? $data['vendorCode'] ?? '');
$currency   = (string)($data['currency'] ?? $data['currency_code'] ?? 'BDT');

// Clean account (your old rule)
$member_account = str_replace("hb6fde", "", $accountRaw);
if (preg_match('/[a-zA-Z]$/', $member_account)) {
    $member_account = substr($member_account, 0, -1);
}
$member_account = trim($member_account);

// If still empty, create a stable fallback user id (so insert never becomes 0)
if ($member_account === '') {
    $member_account = 'unknown_user';
}

// tx_id (important for UNIQUE uq_provider_tx)
$tx_id = (string)($data['tx_id'] ?? $data['txId'] ?? $data['order_id'] ?? $data['orderId'] ?? '');

// If tx_id missing, generate one based on round + time so row always inserts
if ($tx_id === '') {
    $tx_id = ($round_id !== '' ? $round_id : 'round') . '_' . uniqid('tx_', true);
}

// event type
$eventType = strtoupper((string)($data['event_type'] ?? $data['type'] ?? ''));
if ($eventType === '') {
    // simple heuristic
    $eventType = ($win_amount != 0.0) ? 'SETTLE' : 'BET';
}
if (!in_array($eventType, ['BET','SETTLE','CANCEL','REFUND','ADJUST'], true)) {
    $eventType = 'BET';
}

// time
$event_time = null;
$timeRaw = (string)($data['timestamp'] ?? $data['event_time'] ?? $data['time'] ?? '');
if ($timeRaw !== '') {
    $ts = strtotime($timeRaw);
    if ($ts !== false) $event_time = date("Y-m-d H:i:s", $ts);
}
if ($event_time === null) $event_time = date("Y-m-d H:i:s");

// ---------- 2) Wallet update (shonu_kaichila) ----------
$member_account_sql = $conn->real_escape_string($member_account);

// Fetch wallet
$walletAmount = 0.0;
$walletQuery = "SELECT motta FROM shonu_kaichila WHERE balakedara = '$member_account_sql' LIMIT 1";
$walletResult = $conn->query($walletQuery);

if ($walletResult && $walletResult->num_rows > 0) {
    $walletRow = $walletResult->fetch_assoc();
    $walletAmount = (float)$walletRow['motta'];
} else {
    // If user row not found, you can choose to create it (optional)
    // For now keep 0
    $walletAmount = 0.0;
}

// Calculate new balance
$newBalance = round($walletAmount - $bet_amount + $win_amount, 2);

// Update wallet
$updateSql = "UPDATE shonu_kaichila SET motta = '$newBalance' WHERE balakedara = '$member_account_sql'";
$updateStatus = $conn->query($updateSql);
$status = $updateStatus ? 'success' : 'failed';

// ---------- 3) Insert history (user_withdraw_summary) ----------
$provider = 'proxy';

$game_uid_sql   = $conn->real_escape_string($game_uid);
$round_id_sql   = $conn->real_escape_string($round_id);
$vendor_sql     = $conn->real_escape_string($vendorCode);
$currency_sql   = $conn->real_escape_string($currency);
$tx_id_sql      = $conn->real_escape_string($tx_id);
$eventType_sql  = $conn->real_escape_string($eventType);
$event_time_sql = $conn->real_escape_string($event_time);
$raw_sql        = $conn->real_escape_string($raw);

$net_amount = round($win_amount - $bet_amount, 2);

$ins = "
INSERT INTO user_withdraw_summary
(provider, vendor_code, game_uid, username, round_id, bet_id, tx_id, event_type,
 bet_amount, win_amount, valid_amount, net_amount, currency, event_time, raw_json, signature)
VALUES
('$provider', '$vendor_sql', '$game_uid_sql', '$member_account_sql', '$round_id_sql', '', '$tx_id_sql', '$eventType_sql',
 '$bet_amount', '$win_amount', 0, '$net_amount', '$currency_sql', '$event_time_sql',
 CAST('$raw_sql' AS JSON), '')
ON DUPLICATE KEY UPDATE
  event_type=VALUES(event_type),
  bet_amount=VALUES(bet_amount),
  win_amount=VALUES(win_amount),
  net_amount=VALUES(net_amount),
  event_time=VALUES(event_time),
  raw_json=VALUES(raw_json)
";

$insertOk = $conn->query($ins);
if (!$insertOk) {
    file_put_contents(__DIR__ . "/callback_db_error.log",
        date('c') . " INSERT_ERROR: " . $conn->error . "\nSQL: " . $ins . "\n\n",
        FILE_APPEND
    );
}

// ---------- 4) Respond ----------
http_response_code(200);
echo json_encode([
    "credit_amount" => $newBalance,
    "timestamp" => round(microtime(true) * 1000),
    "status" => $status
], JSON_UNESCAPED_UNICODE);
