<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include("../pay/bkash/samparka.php");

date_default_timezone_set('Asia/Dhaka');
$today = date('Y-m-d H:i:s');

/* ================================
   ADMIN WITHDRAW ACCEPT / REJECT
================================ */

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['type'], $_GET['id'])) {

    header('Content-Type: text/html; charset=utf-8');

    $action = $_GET['type'];
    $withdrawalId = (int)$_GET['id'];
    $remark = isset($_GET['remark']) ? trim($_GET['remark']) : '';

    // Only accept valid actions
    if (!in_array($action, ['accept', 'reject'])) {
        die("❌ Invalid action!");
    }

    // Fetch withdraw request
    $stmt = mysqli_prepare($conn,
        "SELECT balakedara, motta, sthiti 
         FROM hintegedukolli 
         WHERE shonu = ? LIMIT 1"
    );
    mysqli_stmt_bind_param($stmt, "i", $withdrawalId);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $withdraw = mysqli_fetch_assoc($res);
    mysqli_stmt_close($stmt);

    if (!$withdraw) {
        die("❌ Withdraw request not found!");
    }

    // Prevent double processing
    if ($withdraw['sthiti'] != 0) {
        echo "<script>
            alert('⚠️ This withdrawal already processed!');
            window.location.href='https://royelclub01.top/admin/';
        </script>";
        exit;
    }

    $userId = $withdraw['balakedara'];
    $amount = $withdraw['motta'];

    /* =====================
       ACCEPT WITHDRAW
    ====================== */
    if ($action === 'accept') {

        $stmt = mysqli_prepare($conn,
            "UPDATE hintegedukolli 
             SET sthiti = 1,
                 tike = 'Accepted',
                 remarks = ?,
                 dinankavannuracisi = ?
             WHERE shonu = ? AND sthiti = 0"
        );
        mysqli_stmt_bind_param($stmt, "ssi", $remark, $today, $withdrawalId);
        mysqli_stmt_execute($stmt);

        if (mysqli_stmt_affected_rows($stmt) > 0) {
            mysqli_stmt_close($stmt);

            echo "<script>
                alert('✅ Withdraw Accepted Successfully');
        window.location.href='https://royelclub01.top/admin/withdraw_accept_list.php';
            </script>";
            exit;
        }

        mysqli_stmt_close($stmt);
        die("❌ Withdraw accept failed!");
    }

    /* =====================
       REJECT WITHDRAW
    ====================== */
    if ($action === 'reject') {

        mysqli_begin_transaction($conn);

        try {
            // Update withdraw status
            $stmt1 = mysqli_prepare($conn,
                "UPDATE hintegedukolli 
                 SET sthiti = 2,
                     tike = 'Rejected',
                     remarks = ?,
                     dinankavannuracisi = ?
                 WHERE shonu = ? AND sthiti = 0"
            );
            mysqli_stmt_bind_param($stmt1, "ssi", $remark, $today, $withdrawalId);
            mysqli_stmt_execute($stmt1);

            if (mysqli_stmt_affected_rows($stmt1) == 0) {
                throw new Exception("Withdraw update failed");
            }

            // Refund user balance
            $stmt2 = mysqli_prepare($conn,
                "UPDATE shonu_kaichila 
                 SET motta = motta + ? 
                 WHERE balakedara = ?"
            );
            mysqli_stmt_bind_param($stmt2, "ds", $amount, $userId);
            mysqli_stmt_execute($stmt2);

            mysqli_commit($conn);

            echo "<script>
                alert('❌ Withdraw Rejected & Amount Refunded');
                window.location.href='https://royelclub01.top/admin/manage_withdraw.php';
            </script>";
            exit;

        } catch (Exception $e) {
            mysqli_rollback($conn);
            die("❌ Error: " . $e->getMessage());
        }
    }
}

echo "⚠️ Invalid Request!";
